#!/usr/bin/perl 
use strict;
use CGI::Carp qw(fatalsToBrowser);
use lib '.';
use XFSConfig;
use CGI;
my $ok = "<br><b style='background:#1a1;color:#fff;padding:2px;'>OK</b>";

my $f = &initCGI;

if($f->{site_settings})
{
   my @fields = qw(temp_dir upload_dir htdocs_dir cgi_dir htdocs_tmp_dir);
   $f->{temp_dir}   = "$f->{cgi_dir}/temp";
   $f->{upload_dir} = "$f->{cgi_dir}/uploads";
   $f->{htdocs_tmp_dir} = "$f->{htdocs_dir}/tmp";
   $f->{htdocs_dir} = "$f->{htdocs_dir}/files";
   mkdir("$f->{cgi_dir}/logs");
   my $conf;
   open(F,"XFSConfig.pm")||die("Can't read XFSConfig");
   $conf.=$_ while <F>;
   close F;
   for my $x (@fields)
   {
      my $val = $f->{$x};
      $conf=~s/$x\s*=>\s*(\S+)\s*,/"$x => '$val',"/e;
   }
   open(F,">XFSConfig.pm")||die("Can't write XFSConfig");
   print F $conf;
   close F;
   print CGI::redirect('install_fs.cgi');
   exit;
}
if($f->{remove_install})
{
   print"Content-type:text/html\n\n";
   unlink('install_fs.cgi');
   print"Can't delete <u>install_fs.cgi</u>, remove it manually<br><br>" if -e 'install_fs.cgi';
   print"<br><b>You can close this window now & continue with server addition in admin panel.</b>";
   exit;
}

print"Content-type:text/html\n\n";
print"<HTML><BODY style='font:13px Arial;'><h2>XFileSharingPro FileServer Installation Script</h2>";
print"<b>1) Permissions Check</b><br><br>";
my $img_dir=$c->{htdocs_tmp_dir};
$img_dir=~s/\/tmp/\/i/;
my $perms = {
               'logs.txt'  	=> 0666,
               'upload.cgi'     => 0755,
               'api.cgi'        => 0755,
               'dl.cgi'         => 0755,
               'up.cgi'         => 0755,
               'uu.cgi'         => 0755,
               'up_flash.cgi'   => 0755,
               'XFSConfig.pm'   => 0666,
               'temp'           => 0777,
               'uploads'        => 0777,
               'logs'           => 0777,
               "$c->{htdocs_dir}"     => 0777,
               "$c->{htdocs_tmp_dir}" => 0777,
               "$img_dir"             => 0777,
            };
my @arr;
for(keys %{$perms})
{
   next unless -e $_;
   next if /^\/\w+$/;
   chmod $perms->{$_}, $_;
   my $chmod = (stat($_))[2] & 07777;
   my $chmod_txt = sprintf("%04o", $chmod);
   push @arr, "<b>$_</b> : $chmod_txt : ".( $chmod == $perms->{$_} ? 'OK' : "<u>ERROR: should be ".sprintf("%04o",$perms->{$_})."</u>" );
}
#chmod 0777, "$c->{htdocs_dir}" if -d "$c->{htdocs_dir}";

print join '<br>', @arr;
if( grep{/ERROR/}@arr )
{
   print"<br><br><u>Fix errors above and refresh this page</u>";
}
else
{
   print"<br><br>All permissions are correct.$ok";
}
   

print"<hr><b>2) FileServer URL / Path Settings</b><br><br>";
if(-d $c->{htdocs_dir} && -d $c->{cgi_dir} && -d $c->{temp_dir} && -d $c->{upload_dir})
{
   print"Settings are correct.$ok";
}
else
{
   my $htdocs_dir = $ENV{DOCUMENT_ROOT};
   my ($cgipath) = $ENV{SCRIPT_FILENAME}=~/^(.+)\//;
print<<EOP
<form method="POST">
<input type="hidden" name="site_settings" value="1">
cgi-bin disk path:<br>
<input type="text" name="cgi_dir" value="$cgipath" size=48><br>
htdocs folder disk path:<br>
<input type="text" name="htdocs_dir" value="$htdocs_dir" size=48><br>
<br>
<input type="submit" value="Save site settings">
</form>
EOP
;

}

print"<hr><b>3) Clean install";
print<<EOP
<form method="POST">
<input type="hidden" name="remove_install" value="1">
<input type="submit" value="Remove install files">
</form>
EOP
;

sub initCGI
{
  my $in = CGI->new();
  my @vals=$in->param();
  my %f;
  for my $k(@vals)
  {
    my @val=$in->param($k);
      if(@val>1){
         $f{$k}=\@val;
      }else{
         $f{$k}=$val[0];
      }
  }
  return \%f;
}
